********************************
** MONETARY SOCIAL ASSISTANCE **
********************************
* conditions that cannot be assesed based on the SILC data
* that would 

* 1. decrease the number of hh receiving MSA:
* land condition (0.5 ha or 1 ha for those incapable for work)
* sale or donation immovable assets
* lifelong support contract

* 2. increase the number of hh receiving MSA:
* Active labour market policy participant
* Did not quit the job within a year 
* Person is in the process of disability check

* currently all income is taken into account for 
* the maans test as the social workers have 
* right to impute income where they see family has
* larger spending, this needs to be tested

**********************************
** extract individual vars *******
**********************************
cd "Z:\work\Baze\SILC_Serbia\2019"
use p-file, clear
merge 1:1 idperson using r-file
drop _merge
merge 1:1 idperson using income
drop _merge

sort idhh idperson

***************************
* set year  ***************
***************************
global year = 2018

* amounts per year
gen baseamount2018 = 8283
gen baseamount2019 = 8508
gen baseamount2020 = 8626

* amount for selected year
global baseamount = baseamount$year
drop baseamount2*
noi di "year=" $year " base amount=" $baseamount

*****************************
* individual conditions *****
*****************************

count
sum age

* household size
bys idhh: egen hsize = sum(age>=0)
sum hsize
label var hsize "Household size"

bys idhh: egen moth_hh = sum(ismother017)
bys idhh: egen fath_hh = sum(isfather017)
bys idhh: egen dip_hh = sum(haspartnerdi)

* single parent
gen singlepar = (ismother017 | isfather017) & ///
				(!haspartner | haspartnerdi)
				
bys idhh: egen hh_singlepar = sum(singlepar)	
replace hh_singlepar = 0 if (moth_hh == fath_hh) ///
				& dip_hh==0
label var hh_singlepar "Single parent household"
drop singlepar moth_hh fath_hh dip_hh

/*
* survivor pension...
gen surv = py110n!=0
bys idhh: egen surv_hh = sum(surv)
tab surv_hh hh_singlepar
replace hh_singlepar = 0 if surv_hh != 0
*/

*****************************
* 1. incapable for work *****
*****************************
gen incap_cond = 0

* over retirement age
replace incap_cond = 1 if age>=65 & female==0
replace incap_cond = 1 if age>=62 & female==1

* children under the age of 15
replace incap_cond = 1 if age<15 

* children under the age of 26 if still in education
replace incap_cond = 1 if (age>=15 & age<=26) & pe010==1
replace incap_cond = 1 if age==15 // no information about education status of this child in SILC

* incapable for work according to the law
replace incap_cond = 1 if pl086>=6
* potvrdila komisija (ako mi daju podatke)

* women with children aged zero
replace incap_cond = 1 if ismother01==1

* agregate on the household level
gen incap_adult = (incap_cond & age>18)
gen incap_child = (incap_cond & age<=18)
bys idhh: egen n_incap_all = sum (incap_cond)
bys idhh: egen n_incap_adult = sum (incap_adult)
bys idhh: egen n_incap_child = sum (incap_child)
label var n_incap_all "Number of persons incapable for work"
label var n_incap_adult "Adults incapable for work"
label var n_incap_child "Children incapable for work"

*****************************
* 2. elgibile for MSA *****
*****************************

gen elig_cond = incap_cond

* if still in education
replace elig_cond = 1 if pe010==1

* unemployed - actively seeking for work
replace elig_cond = 1 if pl020==1

gen elig_adult = (elig_cond & age>18)
gen elig_child = (elig_cond & age<=18)
bys idhh: egen n_elig_all = sum (elig_cond)
bys idhh: egen n_elig_adult = sum (elig_adult)
bys idhh: egen n_elig_child = sum (elig_child)
label var n_elig_all "Number of persons eligilbe for MSA"
label var n_elig_adult "Adults eligilbe for MSA"
label var n_elig_child "Children eligilbe for MSA"
	 
gen incap_cond1 = incap_cond
replace incap_cond1 = 1 if pe010 == 1
bys idhh: egen n_incap1_all = sum (incap_cond1)

drop incap_cond incap_adult incap_child ///
	 elig_cond elig_adult elig_child

**************************************
* 3. Income from individual data *****
**************************************
* !!! neformalna dal se isto ///
* uključuje obzirom da to radi socijalni radnik?

* income from dependant employment
bys idhh: egen yee_n_m_hh = sum(yee_n_m)

* income from self-employment TBD
gen yse_n_m = py050n/12
bys idhh: egen yse_n_m_hh = sum(yee_n_m)

* pensions (including private, disability 
* and survivors) unemployment benefit 
egen penben = rowtotal(py080n py090n py100n ///
					py110n py120n)
replace penben = penben/12 // registered at yearly level
bys idhh: egen penben_hh = sum(penben)
drop yse_n_m penben

* prepare to merge with household data
duplicates drop idhh, force
keep idhh weight hsize - penben_hh
save soc_ass, replace


*****************************
* household conditions *****
*****************************
use h-file, clear
merge 1:m idhh using soc_ass 
drop _merge incap_cond1

**************************************
* 1. Income from household data *****
**************************************

* rent, interests and dividents
gen rent = hy040n/12
gen interest = hy090n/12

* maternity leave?

* alimony, remittances, and other houshold transfers
gen alimony = hy081n/12
gen oth_trans = (hy080n - hy081n)/12 // generalno se ne spominju al tu su idoznake
*=> potentially separation of oth_trans and remittances 
* 	within could increase the precision of MSA simulation

gen income = yee_n_m_hh + /// // income from employment
			 yse_n_m_hh + /// // income from self-employment
			 penben_hh + /// // income from pensions and benefits
			 rent + /// // income from renting land or other property
			 interest + /// // income from interests and dividends
			 alimony  // income from pensions and benefits
			 
replace income = income + oth_trans // income from remitances and other hh_transfers
label var income "Household income for the means test"
drop yee_n_m_hh yse_n_m_hh penben_hh ///
	 rent interest alimony oth_trans

**************************************
* 2. Calculate the amount available **
*    for each household **************
**************************************

* base amount multiplier based on the household structure
gen 	scale = 1 + 0.5*(n_elig_adult-1) + ///
				0.3*n_elig_child
*reform - waving the replacemenet for 6th child
/*replace scale = 1 + 0.5*5 ///
				if n_elig_adult>6
replace scale = 1 + 0.5*(n_elig_adult-1) + ///
				0.3*(6-n_elig_adult) ///
				if n_elig_all>6 & n_elig_adult<=6 */
replace scale = 0 if n_elig_all==0
sum scale
label var scale "Base amount multiplier"

* household is eligilbe for the amount of
gen msa_avail = scale*$baseamount
label var msa_avail "Available level of social assistance"

* 20% increase for hh where all  
* hh members are incapable for work
replace msa_avail = 1.20*msa_avail if n_incap1_all==hsize

* 20% increase for single parent families
replace msa_avail = 1.20*msa_avail if hh_singlepar



******************************
* 3. MEANS TEST **************
******************************
* if the amount available is higher than hh's income
* household is eligilbe for MSA
gen msa = max((msa_avail - income), 0)
label var msa "Monetary social assistance"
* treshold 
replace msa = 0 if msa<1000
sum msa if msa!=0 [iw=weight]

***********************************
* additional household-level ******
* conditions for msa **************
***********************************

******************************
* a. room condition **********
******************************
* if the number of rooms is not higher than the number 
* of hh members, household is eligilbe for MSA
sum hh030
gen room_cond = (hsize >= hh030)
tab room_cond
* dve sobe za osobu koja ima pomoc za negu (ako dobijem podatke)

replace msa = 0 if room_cond==0
sum msa if msa!=0 [iw=weight]


******************************
* b. movable assets condition *****
******************************
* if household does not have movable assets that could 
* be sold to obtain 6xmonthly amount of MSA,
* household is eligible for MSA
* (having a car proxy ********

sum hs110
gen car_cond = (hs110 != 1)
tab car_cond
* dve sobe za osobu koja ima pomoc za negu (ako dobijem podatke)

replace msa = 0 if car_cond==0
sum msa if msa!=0 [iw=weight]


******************************
* 4. MSA YEARLY LEVELS *******
******************************
gen incap_hh = n_incap1_all >= (n_elig_all - n_incap1_all)

* if the majority of the hh members is capable 
* for work msa is received for 9 months
replace msa = 9 * msa if incap_hh == 0

* if the majority of the hh members is incapable 
* for work msa is received for 12 months
replace msa = 12 * msa if incap_hh == 1

sum msa if msa!=0 [iw=weight]

rename msa msa_sim_ref
keep idhh msa_sim_ref
save msa_sim_ref, replace 
